#!/usr/bin/env python
"""
Harmonograf.
Dane pochodzą z wahadeł podłączonych do Arduino. Arduino przekazuje dane
do Raspberry Pi przez szeregowy port USB.
Jest to wersja druga (z ograniczoną liczbą przesyłanych bajtów).
"""
import time                     # Na potrzeby dodawania opóźnień
import os, pygame, sys
from pygame.locals import *
import serial

try:
   ser = serial.Serial('/dev/ttyACM0',115200, timeout=2)
except :
   ser = serial.Serial('/dev/ttyACM1',115200, timeout=2)    

pygame.init()                   # Inicjowanie interfejsu graficznego
os.environ['SDL_VIDEO_WINDOW_POS'] = 'center'
pygame.display.set_caption("Harmonograf")
screen = pygame.display.set_mode([800,800],0,32)
background = pygame.Surface((800,800))

cBackground =(255,255,255)
background.fill(cBackground) # Określanie koloru tła
col = (0,0,0) # Kolor kreski
reading = [0, 0, 0, 0]
lastX = 0
lastY = 0
picture = 1 # Numer rysunku
nextTime = time.time()
timeInc = 0.2 # Aktualizowanie ekranu co 0,2 sekundy
fileName = "harmo"
running = False

def main():
        openPort()
        getData()
        drawData() # Ustawianie początkowych pozycji
        blank_screen()
        while True :
            checkForQuit()
            getData()
            drawData()

def drawData():
        global readings, nextTime, lastX, lastY
        x = reading[0]
        y = reading[1]
        pygame.draw.line(screen,col,(lastX,lastY),(x,y),1)
        lastX = x
        lastY = y
        # Sprawdzanie, czy należy już zaktualizować zawartość ekranu
        if time.time() > nextTime :
             pygame.display.update()
             nextTime = time.time() + timeInc
        
def openPort():
       global running
       ser.flushInput()
       # Nakazanie Arduino, aby rozpoczął wysyłanie danych
       running = True
       ser.write('3')
       ser.write('G')
       
def checkInput(b): # Sprawdzanie, czy otrzymane bajty mają właściwą kolejność
       correct = True
       for i in range(0,4):
            #print i," - " # ,hex(ord(b[i]))
            if (ord(b[i]) >> 6) != i :
               correct = False
       return correct
            
def getData():
   global reading, running
   if running :     
        a = ser.read(4)        
        if checkInput(a) :
            reading[0] = ((ord(a[0]) & 0x1f)<< 5) | (ord(a[1]) &0x1f)
            reading[1] = ((ord(a[2]) & 0x1f)<<5) | (ord(a[3]) &0x1f)
            #print reading[0]," - ",reading[1]
        else:
            correct = False
            while correct == False : # Ponowna synchronizacja
                print "Synchronizacja została utracona ",ser.inWaiting()
                b = ser.read(1)
                t = a[1] + a[2] + a[3] + b[0]
                a = t
                correct = checkInput(a)
        
def blank_screen():
    screen.fill((255,255,255)) # Usuwanie zawartości ekranu
    pygame.display.update()

def terminate(): # Zamykanie programu
    print ("Trwa zamykanie programu – proszę czekać")
    # Nakazanie Arduino zaprzestania wysyłania danych
    ser.write('S')
    ser.close()
    pygame.quit()
    sys.exit()
    
def checkForQuit():
    global col, picture, fileName, running
    event = pygame.event.poll()
    if event.type == pygame.QUIT :
           terminate()
    elif event.type == pygame.KEYDOWN : # Ustalanie wciśniętego klawisza i wykonywanie odpowiednich operacji
         if event.key == pygame.K_ESCAPE :
            terminate()
         if event.key == K_SPACE or event.key == K_DELETE:   
            blank_screen()
         if event.key == K_r :
             col = (255, 0, 0)
         if event.key == K_g :
             col = (0, 255, 0)
         if event.key == K_b :
             col = (0, 0, 255)
         if event.key == K_y :
             col = (255, 255, 0)
         if event.key == K_m :
             col = (255, 0, 255)
         if event.key == K_c :
             col = (0, 255, 255)
         if event.key == K_w :
             col = (255, 255, 255)
         if event.key == K_k :
             col = (0, 0, 0)
         if event.key == K_s : # Sprawdzanie wielkości bufora
             print ser.inWaiting()
         if event.key == K_2 :
             ser.write('2') # Dane z dwóch wahadeł
         if event.key == K_3 :
             ser.write('3') # Dane z trzech wahadeł
         if event.key == K_4 :
             ser.write('4') # Dane z czterech wahadeł
         if event.key == K_5 :
             ser.write('5') # Dane przesyłane z innej pary wahadeł
         if event.key == K_6 :
             ser.write('6') # Dane przesyłane z innych trzech wahadeł
         if event.key == K_h :
             ser.write('S') # stop arduino from sending
             running = False
         if event.key == K_j :
             ser.write('G') # Polecenie zakończenia przesyłania danych przez Arduino
             running = True
         if event.key == K_HOME :
             ser.write('S') # Polecenie rozpoczęcia przesyłania danych przez Arduino
             print "Zapisywanie rysunku do pliku"
             if picture == 1 : # Pierwsze zapisywanie pliku w danej sesji
                fileName = raw_input("Wprowadź nazwę pliku na potrzeby tej sesji ")
             try:
                 pygame.image.save(screen,'harmo/'+fileName+str(picture)+'.png')
             except:
                 os.system('mkdir harmo')
                 pygame.image.save(screen,'harmo/'+fileName+str(picture)+'.png')
             print "Zapisywanie rysunku pod nazwą ",'harmo/'+fileName+str(picture)+'.png'
             picture +=1;
             ser.write('G') # Polecenie rozpoczęcia przesyłania danych przez Arduino
             
if __name__ == '__main__':
    main()   
